#include "stdafx.h"														//
#include <stdio.h>														// sprintf() 
#include <assert.h>														//
#include "RegTools.h"													// 
#include "windows.h"													// HKEY



bool SetDataToRegistry( const char *szAppName, const char *szBin32Path, const bool bShowWindow, const bool bHideCustom )
{
	assert(szAppName);

	HKEY  hKey;
	DWORD size = 512;

	bool bRet=true;

	char szSubKey[512];

	sprintf(szSubKey,"Software\\Crytek\\%s",szAppName);

	// Create and open key and subkey.
	LONG lResult = RegCreateKeyEx(HKEY_CURRENT_USER,szSubKey,0,NULL,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS, NULL, &hKey, NULL) ;

	if(ERROR_SUCCESS != lResult)
		return false;

	{
		lResult = RegSetValueEx(hKey,"Bin32Path", 0, REG_SZ, (BYTE *)szBin32Path, strlen(szBin32Path)+1) ;
		if( ERROR_SUCCESS != lResult )
			bRet=false;
	}

	{
		DWORD dwVal = bShowWindow?1:0;
		lResult = RegSetValueEx(hKey,"ShowWindow", 0, REG_DWORD, (BYTE *)&dwVal, sizeof(dwVal)) ;
		if( ERROR_SUCCESS != lResult )
			bRet=false;
	}

	{
		DWORD dwVal = bHideCustom?1:0;
		lResult = RegSetValueEx(hKey,"HideCustom", 0, REG_DWORD, (BYTE *)&dwVal, sizeof(dwVal)) ;
		if( ERROR_SUCCESS != lResult )
			bRet=false;
	}

	RegCloseKey( hKey );

	return bRet;
}

const char* GetDataFromRegistry( const char *szAppName, bool &bShowWindow, bool &bHideCustom )
{
	assert(szAppName);
	static TCHAR strNull[2] = "";
	static TCHAR strPath[512];
	HKEY  key;
	DWORD type, size = 512;

	char szSubKey[512];

	sprintf(szSubKey,"Software\\Crytek\\%s",szAppName);

	const char *szRet = strNull;

	// Open the appropriate registry key
	LONG result = RegOpenKeyEx( HKEY_CURRENT_USER,szSubKey,0, KEY_READ, &key );
	if( ERROR_SUCCESS != result )
		return szRet;

	{
		result = RegQueryValueEx( key, "Bin32Path", NULL,&type, (BYTE*)strPath, &size );
		if( ERROR_SUCCESS == result )
			szRet=strPath;
	}

	{
		DWORD dwVal;
		size=sizeof(dwVal);

		result = RegQueryValueEx( key, "ShowWindow", NULL,&type, (LPBYTE)&dwVal, &size );

		if(ERROR_SUCCESS==result && type==REG_DWORD)
			bShowWindow = (dwVal!=0);
		else
			bShowWindow=false;
	}

	{
		DWORD dwVal;
		size=sizeof(dwVal);

		result = RegQueryValueEx( key, "HideCustom", NULL,&type, (LPBYTE)&dwVal, &size );

		if(ERROR_SUCCESS==result && type==REG_DWORD)
			bHideCustom = (dwVal!=0);
		else
			bHideCustom=false;
	}

	RegCloseKey( key );

	return szRet;
}



// \return success
bool InvokeResourceCompiler( const char *szAppName, const char *szFileName, const char *szAdditionalSettings )
{
	// make command for execution
	char szRemoteCmdLine[512];

	if(!szAdditionalSettings)
		szAdditionalSettings="";				// better than using default values - the compiler might mess that up

	bool bShowWindow=false, bHideCustom=false;

	const char *szBin32RCPath = GetDataFromRegistry(szAppName,bShowWindow,bHideCustom);

	char szRemoteDirectory[512];
	// we use /nooutput because the file name from Photoshop is temporary and not the one we want to use
	sprintf(szRemoteDirectory, "%s/rc",szBin32RCPath);

	const char *szHideCustom = bHideCustom ? " /userdialogcustom=0" : "";

	// we use /nooutput because the file name from Photoshop is temporary and not the one we want to use
//	sprintf(szRemoteCmdLine, "%s/rc.exe \"%s\" /userdialog=1 %s /nooutput%s",szRemoteDirectory,szFileName,szAdditionalSettings,szHideCustom);
	sprintf(szRemoteCmdLine, "%s/rc.exe \"%s\" /userdialog=1 %s%s",szRemoteDirectory,szFileName,szAdditionalSettings,szHideCustom);

	STARTUPINFO si;
	ZeroMemory( &si, sizeof(si) );
	si.cb = sizeof(si);
	si.dwX = 100;
	si.dwY = 100;
	si.dwFlags = STARTF_USEPOSITION;

	PROCESS_INFORMATION pi;
	ZeroMemory( &pi, sizeof(pi) );

	if( !CreateProcess( NULL, // No module name (use command line). 
		szRemoteCmdLine,				// Command line. 
		NULL,									  // Process handle not inheritable. 
		NULL,									  // Thread handle not inheritable. 
		FALSE,								  // Set handle inheritance to FALSE. 
		bShowWindow?0:CREATE_NO_WINDOW,	// creation flags. 
		NULL,									  // Use parent's environment block. 
		szRemoteDirectory,			// Set starting directory. 
		&si,										// Pointer to STARTUPINFO structure.
		&pi ))									  // Pointer to PROCESS_INFORMATION structure.
	{
		MessageBox(0,"rc.exe (ResourceCompiler not found\n\nCheck the path and try again!","CryTIFPlugin Error:",MB_ICONERROR|MB_OK);
		return false;
	}

	// Wait until child process exits.
	WaitForSingleObject( pi.hProcess, INFINITE );

	// Close process and thread handles. 
	CloseHandle( pi.hProcess );
	CloseHandle( pi.hThread );
	return true;
}

